{
This program performs frame by frame background subtraction and writes the image mean into a csv file

Program DO NOT require initialization file


The input parameters requested from operator:


- Browse and select directory where images are stored
- 'Enter the FILE HEADER' --> enter the file header convention <FILE HEADER><_><Index>.tif
- 'Enter the FIRST frame' --> enter the index number for start
- 'Enter the LAST frame' --> enter the index number for end


Created by Andreas Gahlmann }



const
  	 	  CommonDlgsLib = 'VppCommonDlgs.dll' ;	 	{DLL for common dialog} 
		  InPath='D:\UED4_Data_raw\28082003\';			 	{default path for images}
		  Path2='D:\UED4_Data_raw\Utilities_UED4\';		{default path for initial mask image}
		  Qwst='Do you want to use Patch for saturated pixels?';
		  		  
		  function BrowseFolders( Path:pointer ) : integer ; external CommonDlgsLib ;
		  

var 
	


{************************************************************************}
{ ***	                      Function FieldedFileName 				  ***}									   
{************************************************************************}


function FieldedFileName(FName, ind);
  begin
    FieldedFileName:= FName+'_'+ReplaceStr(Str(ind:4),' ','0',rs_ReplaceAll);		//Attach the index count (with leading zeros) to the file name 
  end; 
	


Procedure SetRegion(var L,T,R,B;Left,Top,Right,Bottom);								//Equate four variables
begin
   L:=Left;
   T:=Top;
   R:=Right;
   B:=Bottom;
end;
  
  
{************************************************************************}
{ ***	                      Function GetFolder	   				  ***}									   
{************************************************************************}

  
function GetFolder( InitPath ) ;
{ Opens the folder browse dialog and returns a folder path }
{ InitPath may be used to set the initial folder (set to '' otherwise) }
{ Returns a null string if Cancel is pressed }

const
  BufSize = 255 ;
  
var
  FolderName ;

begin
  FolderName := InitPath + StringOfChar( ' ',BufSize - Length( InitPath ) ) ;		//Initialize the variable Folder Name
  if BrowseFolders( FolderName ) <> 0 then 			   		   			  	 		//If a folder is selected
    GetFolder := Trim( FolderName )	  												//Return the folder path
else
    GetFolder := '' ;			  													//Return the Null String
end;  { GetFolder }

{------------------------------------>end of Function --GetFolder--}  	

{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}

var
   	Image1, Image2, Image3;					//Image variables
	ind;									//indices
	i,j;									//string varialbes of indices
	F,N;		  							//first and last number of images to process
	FHead1, FHead2, FHead3;					//file headers
	Path;									//path for images
	TRlow, TRup;							//lower and upper intensity threshold
	MeanImage1, MeanImage2, MeanImage3;		//Mean value of sample images
	Ed1;									//Output windows
  
begin
		F:=1;								//the first frame to process
		N:=100;								//the last frame to process
		FHead1:='GS';					    //file header
	//	TRup:=2000;							//upper threshold for rejection
	//	TRlow:=400;							//lower threshold for rejection
	                           
              
		
				   		  Path:=GetFolder( InPath )+'\';	  	  			  								  //Use the default directory or select a new one
                		  if ( Path = '\' ) then halt( 'Directory not selected' ) ;
				   	 	  WriteInfo(Path);			
				   	 	  WriteInfo('This program will generate frame-by-frame subtraction images: Filname1-Filename2' );			
                          GetString('Enter Filename1',FHead1);									  //Display a dialog box and prompt the user to enter a string
                          FHead2:='BG_'+FHead1;
			    		  FHead3:='BGsub_'+FHead1;
			//			  GetString('Enter Filename2',FHead2);									  //Display a dialog box and prompt the user to enter a string
     		//			  GetString('Enter the Filename of the ouput frames',FHead3);		
						  GetNumber('Enter the FIRST frame to be processed',F);					  //Display a dialog box and prompt the user to enter a number
						  GetNumber('Enter the LAST frame to be processed',N);
			//			  GetNumber('Enter the LOWER Rejection Treshold',TRlow);		
			//			  GetNumber('Enter the UPPER Rejection Treshold',TRup);			
						 
						 
  

begin
  	   
       	Ed1 := CreateEditor( 'FHead1' ) ;
		WriteLn( Ed1, 'Frame#' +', '+ FHead1 +', '+ FHead2 +', '+ FHead3) ;
	   	  				   
{---->}	for ind:=F to N do	   
		   begin
			   i:=FieldedFileName('',ind);  										//Convert expression (ind) to a string (with leading zeros)
   		//	   CreateDir(Path + FHead3 + '\'); 										//create subdirectory for output
			   Open(Path+FHead1+i+'.tif',Image1);									//Read the ith sample image from disk
			   Open(Path+FHead2+i+'.tif',Image2);									//Read the ith sample image from disk
		       Image3 := Single(Image1)-Single(Image2);								//Create the output image
			   MeanImage1:=MeanOf(Image1);
			   MeanImage2:=MeanOf(Image2);
			   MeanImage3:=MeanOf(Image3);
			   WriteLn( Ed1, Str(ind)+', '+ Str(MeanImage1)+', '+ Str(MeanImage2)+', '+ Str(MeanImage3)) ;
			   Save(Image3, Path + FHead3+i+'.tif');								//Save the jth sample image
		//	   WriteStatus('Frame# ',ind);											//Display a message in the status bar
 			end  ;
		
		  
	    Save(Ed1, Path + FHead1 + '.csv');	
		Delete(Ed1);			  	   	 		   	  							//delete the output window from the desktop	 
		PlaySound( 'C:\Program Files\Digital Optics\V++\Library\Mac.wav' ) ;	 		 //Play a sound
		WriteInfo('Processing completed!!!');							   				 //Display a message in the status bar

end;
end
